<?php

//*************************************************************************************************
//
//                      Class 'PDFrePROException'
//
//*************************************************************************************************

/**
 * @description PHP Exception class, which will be thrown by the PDFrePRO library, if any error occurs.
 * @package     PDFrePRO
 * @author      RICHTER & POWELEIT GmbH
 * @see         https://www.pdfrepro.de/
 * @version     v3.04
 */
final class PDFrePROException extends Exception
{
    //************************************************************************************************************************************\\
    //                                                                                                                                    \\
    //                                                                Codes                                                               \\
    //                                                                                                                                    \\
    //************************************************************************************************************************************\\

    /**
     * @const integer CODE_MINIMUM_REQUIRED_PHP_VERSION - This code is set for PDFrePROExceptions by default.
     */
    const CODE_DEFAULT                      = 0;

    /**
     * @const integer CODE_MINIMUM_REQUIRED_PHP_VERSION - This code is set for PDFrePROExceptions, if the minimum version requirement for
     *                                                    PHP is not met.
     */
    const CODE_MINIMUM_REQUIRED_PHP_VERSION = 1;

    //*********************************************************************************************
    //
    //                  De- / Constructors
    //
    //*********************************************************************************************

    /**
     * PDFrePROException constructor.
     *
     * @param string            $message             - The error message for this exception.
     * @param integer           $code     (optional) - The error code for this exception.
     * @param Exception | null $previous (optional) - An exception, which previously were thrown.
     */
    public function __construct($message,
        $code     = self::CODE_DEFAULT,
                                Exception $previous = null)
    {
        // Call parent constructor.
        parent::__construct($message,
                            $code,
                            $previous);
    } // End of constructor.

    /**
     * PDFrePROException destructor.
     */
    public function __destruct()
    {
    } // End of destructor.

    //*********************************************************************************************
    //
    //                  General Functions
    //
    //*********************************************************************************************

    /**
     * Get a string representation of this exception.
     *
     * @return string - A string representation of this exception.
     */
    public function __toString()
    {
        return __CLASS__ . ': ' . $this->code . ': ' . $this->message;
    } // End of function '__toString'.

} // End of class 'PDFrePROException'.