
//*************************************************************************************************
//
//                      Package 'PDFrePRO'
//
//*************************************************************************************************

package PDFrePRO;

//*************************************************************************************************
//
//                      Class 'PDFrePROException'
//
//*************************************************************************************************

/**
 * @description JAVA Exception class, which will be thrown by the PDFrePRO library, if any error occurs.
 * @package     PDFrePRO
 * @author      RICHTER & POWELEIT GmbH
 * @see         https://www.pdfrepro.de/
 * @version     v3
 */
public final class PDFrePROException extends Exception
{

	//*********************************************************************************************
	//
	//                  Serialization Attributes
	//
	//*********************************************************************************************
	
	/**
	 * The unique serial version ID of this class.
	 * 
	 * Note:
	 * Don't forget to increment the ID, after you made changes to this class.
	 */
	private static final long serialVersionUID = 0L;
	
	//*********************************************************************************************
	//
	//                  Exception Attributes
	//
	//*********************************************************************************************
	
	/**
	 * The error code of this exception.
	 */
	private int code = -1;
	
    //*********************************************************************************************
    //
    //                  Constructors
    //
    //*********************************************************************************************

    /**
     * PDFrePROException constructor.
     */
	public PDFrePROException()
	{
		// Call parent constructor.
		super();
	} // End of constructor.

    /**
     * PDFrePROException constructor.
     *
     * @param String message - The error message for this exception.
     */
	public PDFrePROException(String message)
	{
		// Call parent constructor.
		super(message);
	} // End of constructor.

    /**
     * PDFrePROException constructor.
     *
     * @param Integer code - The error code for this exception.
     */
	public PDFrePROException(int code)
	{
		// Call parent constructor.
		super();
		
		// Set error code.
		this.code = code;
	} // End of constructor.

    /**
     * PDFrePROException constructor.
     *
     * @param Throwable cause - A throwable object, which caused this exception.
     */
	public PDFrePROException(Throwable cause)
	{
		// Call parent constructor.
		super(cause);
	} // End of constructor.

    /**
     * PDFrePROException constructor.
     *
     * @param String  message - The error message for this exception.
     * @param Integer code    - The error code for this exception.
     */
	public PDFrePROException(String message,
							 int    code)
	{
		// Call parent constructor.
		super(message);
		
		// Set error code.
		this.code = code;
	} // End of constructor.

    /**
     * PDFrePROException constructor.
     *
     * @param String    message - The error message for this exception.
     * @param Throwable cause   - A throwable object, which caused this exception.
     */
	public PDFrePROException(String    message,
							 Throwable cause)
	{
		// Call parent constructor.
		super(message,
			  cause);
	} // End of constructor.

    /**
     * PDFrePROException constructor.
     *
     * @param Integer   code  - The error code for this exception.
     * @param Throwable cause - A throwable object, which caused this exception.
     */
	public PDFrePROException(int       code,
							 Throwable cause)
	{
		// Call parent constructor.
		super(cause);
		
		// Set error code.
		this.code = code;
	} // End of constructor.

    /**
     * PDFrePROException constructor.
     *
     * @param String    message - The error message for this exception.
     * @param Integer   code    - The error code for this exception.
     * @param Throwable cause   - A throwable object, which caused this exception.
     */
	public PDFrePROException(String    message,
							 int 	   code,
							 Throwable cause)
	{
		// Call parent constructor.
		super(message,
			  cause);
		
		// Set error code.
		this.code = code;
	} // End of constructor.

    //*********************************************************************************************
    //
    //                  Exception Methods
    //
    //*********************************************************************************************
    
    /**
     * Get the error code of this exception.
     * 
     * @return Integer - The error code of this exception.
     */
    public int getCode()
    {
    	return this.code;
    } // End of method 'getCode'.
    
    //*********************************************************************************************
    //
    //                  Overridden Methods from Class 'Throwable'
    //
    //*********************************************************************************************

	/**
	 * Get a string representation of this exception.
	 * 
	 * @return String - A string representation of this exception.
	 */
	public String toString()
	{
		return this.getClass().getName() + ": " + this.code + ": " + this.getMessage();
	} // End of method 'toString'.
	
} // End of class 'PDFrePROException'.
