
//*************************************************************************************************
//
//                      Package 'json'
//
//*************************************************************************************************

package json;

//*************************************************************************************************
//
//                      Imports
//
//*************************************************************************************************

// Package 'java.util'.
import java.util.Map;
import java.util.TreeMap;

// Package 'javax.lang.model.type'.
import javax.lang.model.type.NullType;

//*************************************************************************************************
//
//                      Class 'JsonObject'
//
//*************************************************************************************************

/**
 * This class represents a JSON object.
 */
public final class JsonObject extends TreeMap<String,
											  JsonValue>
{

	//*********************************************************************************************
	//
	//                  Serialization Attributes
	//
	//*********************************************************************************************
	
	/**
	 * The unique serial version ID of this class.
	 * 
	 * Note:
	 * Don't forget to increment the ID, after you made changes to this class.
	 */
	private static final long serialVersionUID = 0L;

	//*********************************************************************************************
	//
	//                  Constructors
	//
	//*********************************************************************************************

	/**
	 * JsonObject constructor for empty object.
	 */
	public JsonObject()
	{
		// Call parent constructor.
		super();
	} // End of constructor.

	/**
	 * JsonObject constructor for an object with a single element.
	 * 
	 * @param String   key	 - The key of the element in this instance.
	 * @param NullType value - The value of the element in this instance.
	 */
	public JsonObject(String key,
					  NullType value)
	{
		// Call parent constructor.
		super();
		
		// Add element.
		this.put(key,
				 new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonObject constructor for an object with a single element.
	 * 
	 * @param String  key	- The key of the element in this instance.
	 * @param Boolean value - The value of the element in this instance.
	 */
	public JsonObject(String key,
			  		  Boolean value)
	{
		// Call parent constructor.
		super();

		// Add element.
		this.put(key,
				 new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonObject constructor for an object with a single element.
	 * 
	 * @param String key   - The key of the element in this instance.
	 * @param Number value - The value of the element in this instance.
	 */
	public JsonObject(String key,
			  		  Number value)
	{
		// Call parent constructor.
		super();

		// Add element.
		this.put(key,
				 new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonObject constructor for an object with a single element.
	 * 
	 * @param String key   - The key of the element in this instance.
	 * @param String value - The value of the element in this instance.
	 */
	public JsonObject(String key,
			  		  String value)
	{
		// Call parent constructor.
		super();

		// Add element.
		this.put(key,
				 new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonObject constructor for an object with a single element.
	 * 
	 * @param String    key   - The key of the element in this instance.
	 * @param JsonArray value - The value of the element in this instance.
	 */
	public JsonObject(String key,
			  		  JsonArray value)
	{
		// Call parent constructor.
		super();

		// Add element.
		this.put(key,
				 new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonObject constructor for an object with a single element.
	 * 
	 * @param String     key   - The key of the element in this instance.
	 * @param JsonObject value - The value of the element in this instance.
	 */
	public JsonObject(String key,
			  		  JsonObject value)
	{
		// Call parent constructor.
		super();

		// Add element.
		this.put(key,
				 new JsonValue(value));
	} // End of constructor.
	
	/**
	 * JsonObject constructor for an object with a single element.
	 * 
	 * @param String    key   - The key of the element in this instance.
	 * @param JsonValue value - The value of the element in this instance.
	 */
	public JsonObject(String key,
			  		  JsonValue value)
	{
		// Call parent constructor.
		super();

		// Add element.
		this.put(key,
				 value);
	} // End of constructor.

	/**
	 * JsonObject constructor for copying a map.
	 * 
	 * @param Map<String,
	 * 			  JsonValue> map - The map, which will be copied by this instance.
	 */
	public JsonObject(Map<String,
						  JsonValue> map)
	{
		// Call parent constructor.
		super(map);
	} // End of constructor.

	//*********************************************************************************************
	//
	//                  Overridden Methods of Class 'Object'
	//
	//*********************************************************************************************
	
	/**
	 * Returns a JSON string of this JSON object.
	 */
	public String toString()
	{
		String 	 string = "{";
		String[] keys   = this.keySet().toArray(new String[this.size()]);
		

		for(int i = 0; i < keys.length; i++)
		{
			string += "\"" + keys[i] + "\":" + this.get(keys[i]) + ((i < (this.size() - 1)) ? "," : "");
		}
		
		return string + "}";
	} // End of method 'toString'.
	
} // End of class 'JsonObject'.
