
//*************************************************************************************************
//
//                      Package 'json'
//
//*************************************************************************************************

package json;

//*************************************************************************************************
//
//                      Imports
//
//*************************************************************************************************

// Package 'java.util'.
import java.util.ArrayList;
import java.util.Collection;

// Package 'javax.lang.model.type'.
import javax.lang.model.type.NullType;

//*************************************************************************************************
//
//                      Class 'JsonArray'
//
//*************************************************************************************************

/**
 * This class represents a JSON array.
 */
public final class JsonArray extends ArrayList<JsonValue>
{

	//*********************************************************************************************
	//
	//                  Serialization Attributes
	//
	//*********************************************************************************************
	
	/**
	 * The unique serial version ID of this class.
	 * 
	 * Note:
	 * Don't forget to increment the ID, after you made changes to this class.
	 */
	private static final long serialVersionUID = 0L;
	
	//*********************************************************************************************
	//
	//                  Constructors
	//
	//*********************************************************************************************
	
	/**
	 * JsonArray constructor for empty array.
	 */
	public JsonArray()
	{
		// Call parent constructor.
		super();
	} // End of constructor.

	/**
	 * JsonArray constructor for an array with a single 'null'-value.
	 * 
	 * @param NullType value - The first element in the array of this instance.
	 */
	public JsonArray(NullType value)
	{
		// Call parent constructor.
		super();
		
		// Add value.
		this.add(new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonArray constructor for an array with a single boolean.
	 * 
	 * @param Boolean value - The first element in the array of this instance.
	 */
	public JsonArray(Boolean value)
	{
		// Call parent constructor.
		super();
		
		// Add value.
		this.add(new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonArray constructor for an array with a single number.
	 * 
	 * @param Number value - The first element in the array of this instance.
	 */
	public JsonArray(Number value)
	{
		// Call parent constructor.
		super();
		
		// Add value.
		this.add(new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonArray constructor for an array with a single string.
	 * 
	 * @param String value - The first element in the array of this instance.
	 */
	public JsonArray(String value)
	{
		// Call parent constructor.
		super();
		
		// Add value.
		this.add(new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonArray constructor for an array with a single JSON array.
	 * 
	 * @param JsonArray value - The first element in the array of this instance.
	 */
	public JsonArray(JsonArray value)
	{
		// Call parent constructor.
		super();
		
		// Add value.
		this.add(new JsonValue(value));
	} // End of constructor.

	/**
	 * JsonArray constructor for an array with a single JSON object.
	 * 
	 * @param JsonObject value - The first element in the array of this instance.
	 */
	public JsonArray(JsonObject value)
	{
		// Call parent constructor.
		super();
		
		// Add value.
		this.add(new JsonValue(value));
	} // End of constructor.
	
	/**
	 * JsonArray constructor for an array with a single element.
	 * 
	 * @param JsonValue value - The first element in the array of this instance.
	 */
	public JsonArray(JsonValue value)
	{
		// Call parent constructor.
		super();
		
		// Add value.
		this.add(value);
	} // End of constructor.
	
	/**
	 * JsonArray constructor for an array with any amount of elements.
	 * 
	 * @param JsonValue[] values - The elements, which shall be added to the array of this instance.
	 */
	public JsonArray(JsonValue... values)
	{
		// Call parent constructor.
		super();
		
		// Add values.
		for(JsonValue value : values)
		{
			this.add(value);
		}
	} // End of constructor.
	
	/**
	 * JsonArray constructor for copying a collection.
	 * 
	 * @param Collection<JsonValue> collection - The collection, which will be copied into the array of this instance.
	 */
	public JsonArray(Collection<JsonValue> collection)
	{
		// Call parent constructor.
		super(collection);
	} // End of constructor.

	//*********************************************************************************************
	//
	//                  Overridden Methods of Class 'Object'
	//
	//*********************************************************************************************
	
	/**
	 * Returns a JSON string of this JSON array.
	 */
	public String toString()
	{
		String string = "[";

		for(int i = 0; i < this.size(); i++)
		{
			string += this.get(i).toString() + ((i < (this.size() - 1)) ? "," : "");
		}
		
		return string + "]";
	} // End of method 'toString'.
	
} // End of class 'JsonArray'.
