"""PDFrePRO - Python example script for how to print a PDF of one of your templates!"""

# These imports are necessary for retrieving the editor-url of your template.
import hmac, json, os, sys

from base64   import b64decode
from datetime import datetime
from hashlib  import md5, sha256
from pdfrepro import host, api_key, shared_key, template_id
from urllib   import parse, request

def my_data():
    """The following structure "my_data" represents the data array you want to merge into your PDF document.
    It's normally populated based on your users input or a SQL result.

    The data to print in this example is located in a JSON file which we now read in directly from the
    filesystem:"""

    # Get content of JSON file.
    with open("my_example_data_to_print.json", encoding = "utf-8") as file:
        file_content = file.read()

    # Return encoded JSON.
    return file_content

def send_request(resource, data = {}):
    """This function sends a request to the API of PDFrePRO and returns the response."""

    try:
        # Prepare JSON data.
        data        = {"data":data}
        data_string = json.dumps(data, ensure_ascii = False, separators = (",", ":"))

        # Parse URL.
        url = parse.urlparse(host)

        if (url.port and (url.port != 80) and (url.port != 443)):
            url = url.hostname + ":" + str(url.port)
        else:
            url = url.hostname

        # Initialize headers.
        accept       = "application/json;charset=utf-8"
        content_type = "application/json;charset=utf-8"
        date         = datetime.utcnow().strftime("%a, %d %b %Y %H:%M:%S") + " GMT"

        # Prepare content-hash for authorization header.
        content_hash = md5(data_string.encode()).hexdigest()

        # Prepare hash string for authorization header.
        hash_string  = api_key                        + "\\n"
        hash_string += "POST"                         + "\\n"
        hash_string += resource                       + "\\n"
        hash_string += url                            + "\\n"
        hash_string += content_hash                   + "\\n"
        hash_string += accept                         + "\\n"
        hash_string += content_type                   + "\\n"
        hash_string += str(len(data_string.encode())) + "\\n"
        hash_string += date                           + "\\n"

        # Calculate hash for authorization header.
        hash = hmac.new(shared_key.encode(), hash_string.encode(), sha256).hexdigest()

        # Set headers.
        headers = { "Accept": accept,
                    "Authorization": "SharedKey " + api_key + ":" + hash,
                    "Content-Type": content_type,
                    "Date": date }

        # Send request.
        with request.urlopen(request.Request(host + resource, data = data_string.encode(), headers = headers)) as response:
            content = response.read()

        # Return response.
        return json.loads(content)
    except Exception as exception:
        sys.stderr.write("Request could not be send, properly!\n")

        raise

# Try to print the PDF of your template.
try:
    # Send the request to PDFrePRO-API and get the response.
    response = send_request("/v3/templates/" + template_id + "/pdf", my_data())

    # Get the PDF.
    pdf = response["data"]["pdf"]

    # Store the PDF as file on your desktop.

    # Note, that you may need to set or change "HOMEPATH" variable and / or Desktop directory name, dependent on your
    # operating system.
    file_path = os.path.join(os.environ["HOMEPATH"], "Desktop", "my_first_print_result.pdf")

    with open(file_path, "w+b") as file:
        file.write(b64decode(pdf))

    #Open the PDF file, which got just created.
    os.startfile(file_path)
except Exception as exception:
    # Print any occurring exception.
    print("<pre>" + str(exception) + "</pre>")