"""PDFrePRO - Python example script for how to retrieve the editor-url for one of your templates!"""

# These imports are necessary for retrieving the editor-url of your template.
import hmac, json, sys, webbrowser

from datetime import datetime
from hashlib  import sha256
from pdfrepro import host, api_key, shared_key, template_id
from urllib   import parse, request

def send_request(resource):
    """This function sends a request to the API of PDFrePRO and returns the response."""

    try:
        # Parse URL.
        url = parse.urlparse(host)

        if (url.port and (url.port != 80) and (url.port != 443)):
            url = url.hostname + ":" + str(url.port)
        else:
            url = url.hostname

        # Initialize headers.
        accept = "application/json;charset=utf-8"
        date   = datetime.utcnow().strftime("%a, %d %b %Y %H:%M:%S") + " GMT"

        # Prepare hash string for authorization header.
        hash_string  = api_key  + "\\n"
        hash_string += "GET"    + "\\n"
        hash_string += resource + "\\n"
        hash_string += url      + "\\n"
        hash_string += ""       + "\\n"
        hash_string += accept   + "\\n"
        hash_string += ""       + "\\n"
        hash_string += ""       + "\\n"
        hash_string += date     + "\\n"

        # Calculate hash for authorization header.
        hash = hmac.new(shared_key.encode(), hash_string.encode(), sha256).hexdigest()

        # Set headers.
        headers = { "Accept": accept,
                    "Authorization": "SharedKey " + api_key + ":" + hash,
                    "Date": date }

        # Send request.
        with request.urlopen(request.Request(host + resource, headers = headers)) as response:
            content = response.read()

        # Return response.
        return json.loads(content)
    except Exception as exception:
        sys.stderr.write("Request could not be send, properly!\n")

        raise

# Try to retrieve the editor URL of your template.
# IMPORTANT NOTE:
# Before you start using our PDFrePRO-API, please make sure you have everything
# configured correctly in your account in our Portal (https://portal.pdfrepro.de).
# When you are intending to integrate our PDFrePRO-WYSIWYG-Editor into your own
# application you need to set up a success- and abort-url as follow-up urls to
# let the Editor know where to redirect to when you want to leave the editor.

try:
    # Send the request to PDFrePRO-API and get the response.
    response = send_request("/v3/templates/" + template_id + "/editor-url")

    # Get the editor-url.
    editor_url = response["data"]["url"]

    # Open the PDFrePRO editor by using the URL.
    webbrowser.open(editor_url)
except Exception as exception:
    # Print any occurring exception.
    print("<pre>" + str(exception) + "</pre>")