
//*************************************************************************************************
//
// PDFrePRO - Javascript example script for Node.js on how to retrieve the editor-url for one of your templates!
//
// Note:
// You don't need to install any packages! The entire code uses only functionalities, which are already built-in in
// Node.js.
//
//*************************************************************************************************

// These requirements are necessary for retrieving the editor-url of your template.
var child_process = require("child_process");
var crypto        = require("crypto");
var http          = require("http");
var url           = require("url");

// This file contains your credentials.
require("./my_credentials.js");

// This function sends a request to the API of PDFrePRO. After success, it calls the callback-function with the response
// as argument.
function send_request(resource, callback) {
    try {
        // Parse URL.
        var _url  = new url.URL(host);
        var _host = _url.hostname;

        if(_url.port && (_url.port != 80) && (_url.port != 443)) {
            _host += ":" + _url.port;
        }

        // Initialize headers.
        var accept = "application/json;charset=utf-8";
        var date   = (new Date()).toUTCString() + " GMT";

        // Prepare hash string for authorization header.
        var hash_string  = api_key  + "\\n";
        hash_string += "GET"    + "\\n";
        hash_string += resource + "\\n";
        hash_string += _host    + "\\n";
        hash_string += ""       + "\\n";
        hash_string += accept   + "\\n";
        hash_string += ""       + "\\n";
        hash_string += ""       + "\\n";
        hash_string += date     + "\\n";

        // Calculate hash for authorization header.
        var hmac = crypto.createHmac("sha256", shared_key).update(hash_string);
        var hash = hmac.digest("hex");

        // Set options.
        var options = {
            hostname: _url.hostname,
            port:     _url.port,
            path:     resource,
            headers:  {
                "Accept":        accept,
                "Authorization": "SharedKey " + api_key + ":" + hash,
                "Date":          date
            }
        };

        // Send the request.
        var content = "";
        var request = http.get(options, function(response) {
            // This event is triggered, every time a new chunk of data arrives.
            response.on("data", function(data) {
                content += data;
            });

            // This event is triggered only once, after the whole response has been received.
            response.on("end", function() {
                // Parse content.
                content = JSON.parse(content);

                // Check for error.
                if(content["status"] === "success") {
                    callback(content);
                } else {
                    console.log("Response was not successful!");
                }
            });

            // This event is triggered only, after an error occurred.
            response.on("error", function(error) {
                console.log("<pre>" + error.toString() + "</pre>")
            });
        });

        // This event is triggered only, after an error occurred.
        request.on("error", function(error) {
            console.log("<pre>" + error.toString() + "</pre>")
        });
    } catch(error) {
        console.log("Request could not be send, properly!");

        throw error;
    }
}

// Try to retrieve the editor URL of your template.
// IMPORTANT NOTE:
// Before you start using our PDFrePRO-API, please make sure you have everything
// configured correctly in your account in our Portal (https://portal.pdfrepro.de).
// When you are intending to integrate our PDFrePRO-WYSIWYG-Editor into your own
// application you need to set up a success- and abort-url as follow-up urls to
// let the Editor know where to redirect to when you want to leave the editor.

try {
    // Send the request to PDFrePRO-API and get the response.
    send_request("/v3/templates/" + template_id + "/editor-url", function(response) {
        try {
            // Get the editor-url.
            var editor_url = response["data"]["url"];

            // Get the command for your platform, which opens the URL in your default browser. (This example doesn't
            // cover all platforms.)
            var start = ((process.platform === "darwin") ? "open" : ((process.platform === "win32") ? "start" : "xdg-open"));

            // Open the PDFrePRO editor by using the URL.
            child_process.exec(start + " " + editor_url);
        } catch(error) {
            // Print any occurring error.
            console.log("<pre>" + error.toString() + "</pre>")
        }
    });
} catch(error) {
    // Print any occurring error.
    console.log("<pre>" + error.toString() + "</pre>")
}