
//*************************************************************************************************
//
// PDFrePRO - Javascript example script for Node.js on how to print a PDF of one of your templates!
//
// Note:
// You don't need to install any packages! The entire code uses only functionalities, which are already built-in in
// Node.js.
//
//*************************************************************************************************

// These requirements are necessary for printing a PDF of your template.
var child_process = require("child_process");
var crypto        = require("crypto");
var fs            = require("fs");
var http          = require("http");
var os            = require("os");
var path          = require("path");
var url           = require("url");

// This file contains your credentials.
require("./my_credentials.js");

// The following structure "my_data" represents the data array you want to merge into your PDF document.
// It's normally populated based on your users input or a SQL result.
//
// The data to print in this example is located in a JSON file which we now read in directly from the filesystem:
function my_data() {
    // Get the content of your JSON file.
    var file_content = fs.readFileSync("./my_example_data_to_print.json", { encoding: "utf-8" });

    // Return the encoded JSON.
    return file_content;
}

// This function sends a request to the API of PDFrePRO. After success, it calls the callback-function with the response
// as argument.
function send_request(resource, data = {}, callback) {
    try {
        // Prepare JSON data.
        data            = {
            "data" : data
        };
        var data_string = JSON.stringify(data);

        // Parse URL.
        var _url  = new url.URL(host);
        var _host = _url.hostname;

        if(_url.port && (_url.port != 80) && (_url.port != 443)) {
            _host += ":" + _url.port;
        }

        // Initialize headers.
        var accept         = "application/json;charset=utf-8";
        var content_length = Buffer.byteLength(data_string);
        var content_type   = "application/json;charset=utf-8";
        var date           = (new Date()).toUTCString() + " GMT";

        // Prepare content-hash for authorization header.
        var content_hash = crypto.createHash("md5").update(data_string).digest("hex");

        // Prepare hash string for authorization header.
        var hash_string  = api_key        + "\\n";
        hash_string += "POST"         + "\\n";
        hash_string += resource       + "\\n";
        hash_string += _host          + "\\n";
        hash_string += content_hash   + "\\n";
        hash_string += accept         + "\\n";
        hash_string += content_type   + "\\n";
        hash_string += content_length + "\\n";
        hash_string += date           + "\\n";

        // Calculate hash for authorization header.
        var hmac = crypto.createHmac("sha256", shared_key).update(hash_string);
        var hash = hmac.digest("hex");

        // Set options.
        var options = {
            hostname: _url.hostname,
            port:     _url.port,
            path:     resource,
            method:   "POST",
            headers:  {
                "Accept":         accept,
                "Authorization":  "SharedKey " + api_key + ":" + hash,
                "Content-Length": content_length,
                "Content-Type":   content_type,
                "Date":           date
            }
        };

        // Send the request.
        var content = "";
        var request = http.request(options, function(response) {
            // This event is triggered, every time a new chunk of data arrives.
            response.on("data", function(data) {
                content += data;
            });

            // This event is triggered only once, after the whole response has been received.
            response.on("end", function() {
                // Parse content.
                content = JSON.parse(content);

                // Check for error.
                if(content["status"] === "success") {
                    callback(content);
                } else {
                    console.log("Response was not successful!");
                }
            });

            // This event is triggered only, after an error occurred.
            response.on("error", function(error) {
                console.log("<pre>" + error.toString() + "</pre>")
            });
        });

        // This event is triggered only, after an error occurred.
        request.on("error", function(error) {
            console.log("<pre>" + error.toString() + "</pre>")
        });

        // Write the data into the request body.
        request.write(data_string);
        request.end();
    } catch(error) {
        console.log("Request could not be send, properly!");

        throw error;
    }
}

// Try to print the PDF of your template.
try {
    // Send the request to PDFrePRO-API and get the response.
    send_request("/v3/templates/" + template_id + "/pdf", my_data(), function(response) {
        try {
            // Get the PDF.
            var pdf = response["data"]["pdf"];

            // Store the PDF as file on your desktop.
            var buffer    = new Buffer(pdf, "base64");
            var file_path = os.homedir() + path.sep + "Desktop" + path.sep + "my_first_print_result.pdf";

            fs.writeFileSync(file_path, buffer);

            // Get the command for your platform, which opens the PDF in your default PDF viewer. (This example doesn't
            // cover all platforms.)
            var start = ((process.platform === "darwin") ? "open" : ((process.platform === "win32") ? "start" : "xdg-open"));

            // Open the PDF file, which got just created.
            child_process.exec(start + " " + file_path);
        } catch(error) {
            // Print any occurring error.
            console.log("<pre>" + error.toString() + "</pre>")
        }
    });
} catch(error) {
    // Print any occurring error.
    console.log("<pre>" + error.toString() + "</pre>")
}