
//*************************************************************************************************
//
// PDFrePRO - C# example class for how to retrieve the editor-url for one of your templates!
//
//*************************************************************************************************

/* Tested with .NET versions 4.5, 4.5.1, 4.5.2, 4.6, 4.6.1, 4.7, 4.7.1 and 4.7.2. */
/* Tested with Newtonsof.Json versions 10.0.3 and 12.0.3. */

// Importing the Newtonsoft JSON classes is recommended, because they are used by this example.
using Newtonsoft.Json.Linq;

// These imports are necessary for retrieving the editor-url of your template.
using System;
using System.Diagnostics;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace PDFrePRO {

    public class Retrieve_Editor_Url {

        // IMPORTANT NOTE:
        // Before you start using our PDFrePRO-API, please make sure you have everything
        // configured correctly in your account in our Portal (https://portal.pdfrepro.de).
        // When you are intending to integrate our PDFrePRO-WYSIWYG-Editor into your own
        // application you need to set up a success- and abort-url as follow-up urls to
        // let the Editor know where to redirect to when you want to leave the editor.

        // The following settings should you copy from your account in the PDFrePRO portal:

        // One of your personal API keys, which normally represents one of your applications.
        public static string apiKey     = "<your-api-key>";

        // The associated shared key to your chosen API key.
        public static string sharedKey  = "<your-shared-key>";

        // One of your prepared templates, for which you want to retrieve the editor-url.
        public static string templateId = "<your-template-ID>";

        public static void Main(string[] args) {
            try {
                // Send the request to PDFrePRO-API and get the response.
                JObject response = SendRequest("/v3/templates/" + templateId + "/editor-url").Result;

                // Get the editor-url.
                string editorUrl = response.GetValue("data").Value<string>("url");

                // Open the PDFrePRO editor by using the URL.
                Process.Start(editorUrl);
            } catch (Exception exception) {
                // Print any occurring exception.
                Console.WriteLine("<pre>" + exception.ToString() + "</pre>");
            }
        }

        // This is the host address of PDFrePRO-API.
        private static string host = "https://api.pdfrepro.de";

        // This method sends a request to the API of PDFrePRO and returns the response.
        private static async Task<JObject> SendRequest(string resource) {
            try {
                // Initialize an HTTP client.
                Uri        uri    = new Uri(host + resource);
                HttpClient client = new HttpClient();

                // Initialize headers.
                string accept = "application/json;charset=utf-8";
                string date   = DateTime.UtcNow.ToString("ddd, dd MMM yyyy HH:mm:ss", new System.Globalization.CultureInfo("en-US")) + " GMT";

                // Prepare hash string for authorization header.
                string hashString  = apiKey                                                     + "\\n";
                       hashString += "GET"                                                      + "\\n";
                       hashString += resource                                                   + "\\n";
                       hashString += (uri.IsDefaultPort ? uri.Host : uri.Host + ":" + uri.Port) + "\\n";
                       hashString += ""                                                         + "\\n";
                       hashString += accept                                                     + "\\n";
                       hashString += ""                                                         + "\\n";
                       hashString += ""                                                         + "\\n";
                       hashString += date                                                       + "\\n";

                // Calculate hash for authorization header.
                HMACSHA256 hmac = new HMACSHA256(Encoding.UTF8.GetBytes(sharedKey));
                string     hash = BitConverter.ToString(hmac.ComputeHash(Encoding.UTF8.GetBytes(hashString))).Replace("-", "");

                hmac.Dispose();

                // Set headers.
                client.DefaultRequestHeaders.Add("Accept",        accept);
                client.DefaultRequestHeaders.Add("Authorization", "SharedKey " + apiKey + ":" + hash);
                client.DefaultRequestHeaders.Add("Date",          date);

                // Get response message.
                HttpResponseMessage responseMessage = await client.GetAsync(uri);

                // Get response content.
                string responseContent = await responseMessage.Content.ReadAsStringAsync();

                // Return response.
                return await Task.Run(() => JObject.Parse(responseContent));
            } catch (Exception exception) {
                throw new Exception("Request could not be send, properly!", exception);
            }
        }

    }

}
